-------------------------------------------------------
-- Created by Ben Cope of Imperial College (March 2006)
-- Top Level for Filter block
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;

library UNISIM;
use UNISIM.VComponents.all;

LIBRARY work;
USE work.Constants.ALL;
USE work.ALL;

ENTITY FIFO_block IS
    PORT (clock : IN STD_LOGIC;
			 reset : IN STD_LOGIC;
			 enable : IN STD_LOGIC;
			 RGB_in : IN CHANNEL_TYPE;
			 RGB_out : OUT CHANNEL_TYPE);
END FIFO_block;

ARCHITECTURE inside OF FIFO_block IS

 CONSTANT FIFO_size : INTEGER := image_dim-n;

 SIGNAL fifo_input, fifo_output: STD_LOGIC_VECTOR(31 DOWNTO 0);
 SIGNAL fifo_addrA, fifo_addrB: STD_LOGIC_VECTOR(8 DOWNTO 0);

BEGIN

 --------------------------------------------
 -- MEMORY INSTANTIATIONS
 --------------------------------------------

  RAMB16_S36_S36_inst : RAMB16_S36_S36
   port map (
    DOA => open,      -- Port A 32-bit Data Output
    DOB => fifo_output, -- Port B 32-bit Data Output
    DOPA => open,    -- Port A 4-bit Parity Output
    DOPB => open,    -- Port B 4-bit Parity Output
    ADDRA => fifo_addrA,  -- Port A 9-bit Address Input
    ADDRB => fifo_addrB,  -- Port B 9-bit Address Input
    CLKA => clock,    -- Port A Clock
    CLKB => clock,    -- Port B Clock
    DIA => fifo_input,      -- Port A 32-bit Data Input
    DIB => (OTHERS => '0'),      -- Port B 32-bit Data Input
    DIPA => (OTHERS => '0'),    -- Port A 4-bit parity Input
    DIPB => (OTHERS => '0'),    -- Port-B 4-bit parity Input
    ENA => '1',      -- Port A RAM Enable Input
    ENB => '1',      -- PortB RAM Enable Input
    SSRA => reset,    -- Port A Synchronous Set/Reset Input
    SSRB => reset,    -- Port B Synchronous Set/Reset Input
    WEA => enable,      -- Port A Write Enable Input
    WEB => '0'       -- Port B Write Enable Input
   );
 
 --------------------------------------------
 -- CONCURRENT ASSIGNMENTS
 --------------------------------------------

 fifo_input(31 DOWNTO 24) <= RGB_in.RGB(0);
 fifo_input(23 DOWNTO 16) <= RGB_in.RGB(1);
 fifo_input(15 DOWNTO 8) <= RGB_in.RGB(2);
 fifo_input(7) <= RGB_in.valid;

 RGB_out.RGB(0) <= fifo_output(31 DOWNTO 24);
 RGB_out.RGB(1) <= fifo_output(23 DOWNTO 16);
 RGB_out.RGB(2) <= fifo_output(15 DOWNTO 8);
 RGB_out.valid <= fifo_output(7);

 --------------------------------------------
 -- HANDLE FIFO ADDRESS POINTERS
 --------------------------------------------

 addresses: PROCESS

 BEGIN
  WAIT UNTIL Rising_Edge(clock);
   IF (reset = '1') THEN
    fifo_addrA <= (OTHERS => '0');
    fifo_addrB <= (OTHERS => '0');
    fifo_addrB(0) <= '1';
   ELSE

--    IF enable = '1' THEN
     
     -- Advance fifo_addrA
--     fifo_addrA <= unsigned(fifo_addrA) + 1;
--     IF unsigned(fifo_addrA) = unsigned(conv_std_logic_vector(FIFO_size-1,9)) THEN
--      fifo_addrA <= (OTHERS => '0');
--     END IF;
     fifo_addrA <= fifo_addrB;

     -- Advance fifo_addrB
     fifo_addrB <= unsigned(fifo_addrB) + 1;
     IF unsigned(fifo_addrB) = unsigned(conv_std_logic_vector(FIFO_size-1,9)) THEN
      fifo_addrB <= (OTHERS => '0');
     END IF;

--    END IF;
   END IF;
 END PROCESS addresses;

END inside;